<?php

class EWRporta_DataWriter_Cache extends XenForo_DataWriter
{
	protected $_existingDataErrorPhrase = 'requested_page_not_found';

	protected function _getFields()
	{
		return array(
			'EWRporta_cache' => array(
				'page_id'		=> array('type' => self::TYPE_UINT, 'required' => true),
				'cache_date'	=> array('type' => self::TYPE_UINT, 'required' => true),
				'cache_content'	=> array('type' => self::TYPE_STRING, 'required' => true),
			)
		);
	}

	protected function _getExistingData($data)
	{
		if (!$pageID = $this->_getExistingPrimaryKey($data, 'page_id'))
		{
			return false;
		}

		return array('EWRporta_cache' => $this->getModelFromCache('EWRporta_Model_Cache')->getCacheByID($pageID));
	}

	protected function _getUpdateCondition($tableName)
	{
		return 'page_id = ' . $this->_db->quote($this->getExisting('page_id'));
	}

	protected function _preSave()
	{
		$this->set('cache_date', time());
	}
}